--------------------------------------------------------------------------------
-- SCHEMA
--
-- see 00 Init.sql for comments !!!
--------------------------------------------------------------------------------
GRANT USAGE ON SCHEMA tsystem_security TO "FREDA_NFCLOGIN";
GRANT USAGE ON SCHEMA tsystem_security TO "BDE";


--------------------------------------------------------------------------------
-- USER(S) / MASTER-LOGIN-ROLES
--
-- see 00 Init.sql for comments !!!
--------------------------------------------------------------------------------
GRANT "SYS.Prodat-User" TO "FREDA_NFCLOGIN";


--------------------------------------------------------------------------------
-- FUNCTIONS
--
-- see 00 Init.sql for comments !!!
--
-- # ONLY MASTER-LOGIN-ROLES are allowed to execute
-- # tsystem.delegatedlogin_masterlogin_revokerole(text) is the exception, this needs to be public !!!
-- # tsystem_security.delegatedlogin_check_bde_rfid(text) is the exception, BDE role needs it
--------------------------------------------------------------------------------


-- tsystem.delegatedlogin_masterlogin_revokerole(text)
ALTER FUNCTION tsystem.delegatedlogin_masterlogin_revokerole(text)
  OWNER TO postgres;

REVOKE ALL ON FUNCTION tsystem.delegatedlogin_masterlogin_revokerole(text) FROM PUBLIC;
GRANT EXECUTE ON FUNCTION tsystem.delegatedlogin_masterlogin_revokerole(text) TO PUBLIC;

-- tsystem.delegatedlogin_check_rfid(text, text)
ALTER FUNCTION tsystem.delegatedlogin_check_rfid(text, text)
  OWNER TO postgres;

REVOKE ALL ON FUNCTION tsystem.delegatedlogin_check_rfid(text, text) FROM PUBLIC;
GRANT EXECUTE ON FUNCTION tsystem.delegatedlogin_check_rfid(text, text) TO PUBLIC;

-- tsystem_security.delegatedlogin_masterlogin_grantrole(text)
ALTER FUNCTION tsystem_security.delegatedlogin_masterlogin_grantrole(text)
  OWNER TO postgres;

GRANT EXECUTE ON FUNCTION tsystem_security.delegatedlogin_masterlogin_grantrole(text) TO "FREDA_NFCLOGIN";
REVOKE ALL ON FUNCTION tsystem_security.delegatedlogin_masterlogin_grantrole(text) FROM PUBLIC;

-- tsystem_security.delegatedlogin_check_bde_rfid(text)
ALTER FUNCTION tsystem_security.delegatedlogin_check_bde_rfid(text)
  OWNER TO postgres;

GRANT EXECUTE ON FUNCTION tsystem_security.delegatedlogin_check_bde_rfid(text) TO "FREDA_NFCLOGIN";
GRANT EXECUTE ON FUNCTION tsystem_security.delegatedlogin_check_bde_rfid(text) TO "BDE";
REVOKE ALL ON FUNCTION tsystem_security.delegatedlogin_check_bde_rfid(text) FROM PUBLIC;

-- tsystem_security.delegatedlogin_login_rfid(text, text)
ALTER FUNCTION tsystem_security.delegatedlogin_login_rfid(text, text)
  OWNER TO postgres;

GRANT EXECUTE ON FUNCTION tsystem_security.delegatedlogin_login_rfid(text, text) TO "FREDA_NFCLOGIN";
REVOKE ALL ON FUNCTION tsystem_security.delegatedlogin_login_rfid(text, text) FROM PUBLIC;
